<?php

namespace Tests\Feature\Http\Controllers\Api;

use App\Http\Resources\ProjectResource;
use App\Models\Project;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class ProjectsControllerTest extends TestCase
{
    use RefreshDatabase;

    public function test_it_returns_projects(): void
    {
        $projects = Project::factory()->count(3)->create();
        $resource = ProjectResource::collection($projects);

        $this->get(route("api.projects.index", ["lang" => "en"]))
            ->assertOk()
            ->assertJson($resource->response()->getData(true));
    }

    public function test_it_fetches_project_by_id(): void
    {
        $project = Project::factory()->create();

        $this->get(route("api.projects.show", ["project" => $project->id]))
            ->assertOk()
            ->assertJson([
                "data" => [
                    "type" => "project",
                    "id" => (string) $project->id,
                    "attributes" => [
                        "title" => $project->title,
                        "subtitle" => $project->subtitle,
                        "logo" => $project->getFirstMediaUrl("logo"),
                        "image" => $project->getFirstMediaUrl("image"),
                        "numberOfStaff" => $project->number_of_staff,
                        "numberOfLocations" => $project->number_of_locations,
                        "startingYear" => $project->starting_year,
                        "contractDuration" => $project->contract_duration,
                        "createdAt" => $project->created_at->toISOString(),
                        "updatedAt" => $project->updated_at->toISOString(),
                    ],
                ],
            ]);
    }
}
